import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:cracked_block', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const selectedItem = player.getComponent('equippable').getEquipment("Mainhand")
            if (selectedItem?.typeId === 'v360:chisel') {
                if (block?.typeId === 'v360:cracked_stone') {
                    block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot cracked_stone`)
                    player.getComponent('inventory').container.setItem(player.selectedSlot, selectedItem)
                    block.setType('minecraft:stone')
                }
                else if (block?.typeId === 'v360:cracked_deepslate') {
                    block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot cracked_deepslate`)
                    player.getComponent('inventory').container.setItem(player.selectedSlot, selectedItem)
                    block.setType('minecraft:deepslate')
                }
            }
        }
    })
})

world.beforeEvents.playerInteractWithBlock.subscribe((data) => {
    const block = data.block
    const player = data.player
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    if (selectedItem?.typeId === 'v360:chisel') {
        system.run(() => {
            if (block.typeId === 'minecraft:stone') {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} minecraft:stonebrick["stone_brick_type"="chiseled"]`)
            }
            else if (block.typeId === 'minecraft:polished_deepslate') {
                block.setType('minecraft:chiseled_deepslate')
            }
            else if (block.typeId === 'minecraft:polished_blackstone') {
                block.setType('minecraft:chiseled_polished_blackstone')
            }
            else if (block.typeId === 'minecraft:nether_brick') {
                block.setType('minecraft:chiseled_nether_bricks')
            }
            else if (block.typeId === 'minecraft:polished_tuff') {
                block.setType('minecraft:chiseled_tuff')
            }
            else if (block.typeId === 'minecraft:tuff_bricks') {
                block.setType('minecraft:chiseled_tuff_brick')
            }
            else if (block.typeId === 'v360:polished_calcite') {
                block.setType('v360:chiseled_calcite')
            }
            else if (block.typeId === 'v360:polished_amphibolite') {
                block.setType('v360:chiseled_amphibolite')
            }
            else if (block.typeId === 'v360:polished_limestone') {
                block.setType('v360:chiseled_limestone')
            }
            else if (block.typeId === 'v360:dripstone_bricks') {
                block.setType('v360:chiseled_dripstone_brick')
            }
            else if (block.typeId === 'v360:polished_rootstone') {
                block.setType('v360:chiseled_rootstone')
            }
        })
    }
})